using System;
using System.Collections;
using System.Data;
using System.Drawing;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using CONTROLS = gov.va.med.vbecs.GUI.controls;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmDailyReagentRackQC
	/// </summary>
	public class FrmDailyReagentRackQC : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.ToolTip toolTip1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Data.DataColumn dataColumn4;
		private System.Data.DataColumn dataColumn5;
		private System.Data.DataColumn dataColumn6;
		private System.Data.DataColumn dataColumn7;
		private System.Data.DataColumn dataColumn8;
		private System.Data.DataColumn dataColumn9;
		private System.Data.DataColumn dataColumn10;
		private System.Data.DataColumn dataColumn11;
		private System.Data.DataSet dataSet1;
		private System.Data.DataTable dataTable1;
		private System.Windows.Forms.TabControl tabResults;
		private System.Windows.Forms.Panel pnlGrid;
		private gov.va.med.vbecs.GUI.controls.VbecsDataGrid dgRack;
		private System.Windows.Forms.DataGridTableStyle dataGridTableStyle1;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.TabPage[] pageRacks;
		private DataTable _dtRacks;
		private DataTable[] _dtRackTestResults;
		private DataTable[] _dtLotNumbers;
		private int _nActiveRack;
		private BOL.RackTest _rackTest;
		private gov.va.med.vbecs.GUI.controls.DataGridKeyTrapTextBoxColumn dataGridTextBoxColumn1;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn2;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn3;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn4;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn5;
		private gov.va.med.vbecs.GUI.DataGridKeyTrapTextBoxColumn dataGridTextBoxColumn6;
		private gov.va.med.vbecs.GUI.DataGridKeyTrapTextBoxColumn dataGridTextBoxColumn7;
		private gov.va.med.vbecs.GUI.DataGridKeyTrapTextBoxColumn dataGridTextBoxColumn8;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn9;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn10;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn11;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn12;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn13;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn14;
		private System.Windows.Forms.Panel pnlQCTests;
		private System.Windows.Forms.GroupBox grpValidEntries;
		private System.Windows.Forms.Label lblValidEntries;
		private Hashtable resultLookup;
		private int _LeftHiddenColumn = 5;
		private int _RightHiddenColumn = 7;
		private int _RowCount = 0;
		private int _lastValidRow = 0;
		private int _previousRow = 0;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn15;
		private System.Windows.Forms.GroupBox grpKey;
		private System.Windows.Forms.Label lblValid;
		private System.Windows.Forms.Label lblWarning;
		private System.Windows.Forms.Label lblValidText;
		private System.Windows.Forms.Label lblWarningText;
		private System.Windows.Forms.Label lblError;
		private System.Windows.Forms.Label lblErrorText;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnInvalidate;
		private int _lastValidColumn = 0;
		private Common.WorkloadProcessID [] _workloadProcessIds;
		private string _testingTech;
		private DateTime _testDateTime;
		private bool _keyPressEventHandled;


		enum RowIndicator
		{
			Valid = 0,
			Warning,
			Error,
			Empty
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="dtRacks"></param>
		/// <param name="dtLotNumbers"></param>
		/// <param name="testingTech"></param>
		/// <param name="testDateTime"></param>
		public FrmDailyReagentRackQC(DataTable dtRacks, DataTable[] dtLotNumbers, string testingTech, DateTime testDateTime)
		{		
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			_nActiveRack = 0;
			this._dtRacks = dtRacks;
			_rackTest = new BOL.RackTest();
			_dtLotNumbers = dtLotNumbers;

			InitializeCustomComponents();
			SetComponentProperties();
			InitializeLookup();
			LoadRackTestResults();
			_testingTech = testingTech;
			_testDateTime = testDateTime;
			this._keyPressEventHandled = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmDailyReagentRackQC));
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.btnCancel = new System.Windows.Forms.Button();
			this.dgRack = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.dataGridTableStyle1 = new System.Windows.Forms.DataGridTableStyle();
			this.dataGridTextBoxColumn1 = new gov.va.med.vbecs.GUI.controls.DataGridKeyTrapTextBoxColumn();
			this.dataGridTextBoxColumn2 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn3 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn4 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn5 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn9 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn10 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn11 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn12 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn13 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn14 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn15 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataTable1 = new System.Data.DataTable();
			this.dataColumn4 = new System.Data.DataColumn();
			this.dataColumn5 = new System.Data.DataColumn();
			this.dataColumn6 = new System.Data.DataColumn();
			this.dataColumn7 = new System.Data.DataColumn();
			this.dataColumn8 = new System.Data.DataColumn();
			this.dataColumn9 = new System.Data.DataColumn();
			this.dataColumn10 = new System.Data.DataColumn();
			this.dataColumn11 = new System.Data.DataColumn();
			this.dataSet1 = new System.Data.DataSet();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.tabResults = new System.Windows.Forms.TabControl();
			this.pnlGrid = new System.Windows.Forms.Panel();
			this.pnlQCTests = new System.Windows.Forms.Panel();
			this.grpKey = new System.Windows.Forms.GroupBox();
			this.lblErrorText = new System.Windows.Forms.Label();
			this.lblError = new System.Windows.Forms.Label();
			this.lblWarningText = new System.Windows.Forms.Label();
			this.lblValidText = new System.Windows.Forms.Label();
			this.lblWarning = new System.Windows.Forms.Label();
			this.lblValid = new System.Windows.Forms.Label();
			this.grpValidEntries = new System.Windows.Forms.GroupBox();
			this.lblValidEntries = new System.Windows.Forms.Label();
			this.btnInvalidate = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			((System.ComponentModel.ISupportInitialize)(this.dgRack)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).BeginInit();
			this.grpImage.SuspendLayout();
			this.pnlGrid.SuspendLayout();
			this.pnlQCTests.SuspendLayout();
			this.grpKey.SuspendLayout();
			this.grpValidEntries.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
			this.vbecsLogo1.Title = "Daily QC - Enter Results";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 507);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(662, 496);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// dgRack
			// 
			this.dgRack.AllowSorting = false;
			this.dgRack.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgRack.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgRack.CaptionVisible = false;
			this.dgRack.DataMember = "";
			this.dgRack.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgRack.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgRack.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgRack.Location = new System.Drawing.Point(0, 0);
			this.dgRack.Name = "dgRack";
			this.dgRack.PreferredColumnWidth = 70;
			this.dgRack.RowHeadersVisible = false;
			this.dgRack.Size = new System.Drawing.Size(684, 350);
			this.dgRack.TabIndex = 0;
			this.dgRack.TableStyles.AddRange(new System.Windows.Forms.DataGridTableStyle[] {
																							   this.dataGridTableStyle1});
			this.dgRack.ToolTipColumn = -1;
			this.dgRack.CurrentCellChanged += new System.EventHandler(this.dgRack_CurrentCellChanged);
			// 
			// dataGridTableStyle1
			// 
			this.dataGridTableStyle1.AllowSorting = false;
			this.dataGridTableStyle1.DataGrid = this.dgRack;
			this.dataGridTableStyle1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGridTableStyle1.MappingName = "";
			this.dataGridTableStyle1.RowHeadersVisible = false;
			// 
			// dataGridTextBoxColumn1
			// 
			this.dataGridTextBoxColumn1.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.dataGridTextBoxColumn1.Format = "";
			this.dataGridTextBoxColumn1.FormatInfo = null;
			this.dataGridTextBoxColumn1.MappingName = "TestResultIndicator";
			this.dataGridTextBoxColumn1.ProcessAcross = false;
			this.dataGridTextBoxColumn1.ReadOnly = true;
			this.dataGridTextBoxColumn1.Width = 20;
			// 
			// dataGridTextBoxColumn2
			// 
			this.dataGridTextBoxColumn2.Format = "";
			this.dataGridTextBoxColumn2.FormatInfo = null;
			this.dataGridTextBoxColumn2.HeaderText = "Reagent Type";
			this.dataGridTextBoxColumn2.MappingName = "ReagentTypeName";
			this.dataGridTextBoxColumn2.ReadOnly = true;
			this.dataGridTextBoxColumn2.Width = 130;
			// 
			// dataGridTextBoxColumn3
			// 
			this.dataGridTextBoxColumn3.Format = "";
			this.dataGridTextBoxColumn3.FormatInfo = null;
			this.dataGridTextBoxColumn3.HeaderText = "Test With";
			this.dataGridTextBoxColumn3.MappingName = "TestWithName";
			this.dataGridTextBoxColumn3.ReadOnly = true;
			this.dataGridTextBoxColumn3.Width = 275;
			// 
			// dataGridTextBoxColumn4
			// 
			this.dataGridTextBoxColumn4.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.dataGridTextBoxColumn4.Format = "";
			this.dataGridTextBoxColumn4.FormatInfo = null;
			this.dataGridTextBoxColumn4.HeaderText = "Min Result";
			this.dataGridTextBoxColumn4.MappingName = "ExpectedMinimumReactions";
			this.dataGridTextBoxColumn4.ReadOnly = true;
			this.dataGridTextBoxColumn4.Width = 60;
			// 
			// dataGridTextBoxColumn5
			// 
			this.dataGridTextBoxColumn5.Format = "";
			this.dataGridTextBoxColumn5.FormatInfo = null;
			this.dataGridTextBoxColumn5.HeaderText = "Phase";
			this.dataGridTextBoxColumn5.MappingName = "ReactivityPhaseText";
			this.dataGridTextBoxColumn5.ReadOnly = true;
			this.dataGridTextBoxColumn5.Width = 40;
			// 
			// dataGridTextBoxColumn9
			// 
			this.dataGridTextBoxColumn9.Format = "";
			this.dataGridTextBoxColumn9.FormatInfo = null;
			this.dataGridTextBoxColumn9.MappingName = "ReagentGuid";
			this.dataGridTextBoxColumn9.Width = 0;
			// 
			// dataGridTextBoxColumn10
			// 
			this.dataGridTextBoxColumn10.Format = "";
			this.dataGridTextBoxColumn10.FormatInfo = null;
			this.dataGridTextBoxColumn10.MappingName = "ReactivityPhaseCode";
			this.dataGridTextBoxColumn10.ReadOnly = true;
			this.dataGridTextBoxColumn10.Width = 0;
			// 
			// dataGridTextBoxColumn11
			// 
			this.dataGridTextBoxColumn11.Format = "";
			this.dataGridTextBoxColumn11.FormatInfo = null;
			this.dataGridTextBoxColumn11.MappingName = ARTIFICIAL.IndicatorMessage;
			this.dataGridTextBoxColumn11.ReadOnly = true;
			this.dataGridTextBoxColumn11.Width = 0;
			// 
			// dataGridTextBoxColumn12
			// 
			this.dataGridTextBoxColumn12.Format = "";
			this.dataGridTextBoxColumn12.FormatInfo = null;
			this.dataGridTextBoxColumn12.MappingName = "ReagentTypeId";
			this.dataGridTextBoxColumn12.ReadOnly = true;
			this.dataGridTextBoxColumn12.Width = 0;
			// 
			// dataGridTextBoxColumn13
			// 
			this.dataGridTextBoxColumn13.Format = "";
			this.dataGridTextBoxColumn13.FormatInfo = null;
			this.dataGridTextBoxColumn13.MappingName = "ReadOnlyIsResults";
			this.dataGridTextBoxColumn13.ReadOnly = true;
			this.dataGridTextBoxColumn13.Width = 0;
			// 
			// dataGridTextBoxColumn14
			// 
			this.dataGridTextBoxColumn14.Format = "";
			this.dataGridTextBoxColumn14.FormatInfo = null;
			this.dataGridTextBoxColumn14.MappingName = "ReadOnlyIatResults";
			this.dataGridTextBoxColumn14.ReadOnly = true;
			this.dataGridTextBoxColumn14.Width = 0;
			// 
			// dataGridTextBoxColumn15
			// 
			this.dataGridTextBoxColumn15.Format = "";
			this.dataGridTextBoxColumn15.FormatInfo = null;
			this.dataGridTextBoxColumn15.MappingName = "ReadOnlyCcResults";
			this.dataGridTextBoxColumn15.ReadOnly = true;
			this.dataGridTextBoxColumn15.Width = 0;
			// 
			// dataTable1
			// 
			this.dataTable1.Columns.AddRange(new System.Data.DataColumn[] {
																			  this.dataColumn4,
																			  this.dataColumn5,
																			  this.dataColumn6,
																			  this.dataColumn7,
																			  this.dataColumn8,
																			  this.dataColumn9,
																			  this.dataColumn10,
																			  this.dataColumn11});
			this.dataTable1.TableName = "Table1";
			// 
			// dataColumn4
			// 
			this.dataColumn4.ColumnName = "Reagent Type";
			this.dataColumn4.ReadOnly = true;
			// 
			// dataColumn5
			// 
			this.dataColumn5.ColumnName = "Test With";
			this.dataColumn5.ReadOnly = true;
			// 
			// dataColumn6
			// 
			this.dataColumn6.ColumnName = "Expected Results";
			this.dataColumn6.ReadOnly = true;
			// 
			// dataColumn7
			// 
			this.dataColumn7.Caption = "Phase of Reactivity Tests";
			this.dataColumn7.ColumnName = "Phase of Reactivity Tests";
			this.dataColumn7.ReadOnly = true;
			// 
			// dataColumn8
			// 
			this.dataColumn8.ColumnName = "IS Results";
			// 
			// dataColumn9
			// 
			this.dataColumn9.ColumnName = "IAT Results";
			// 
			// dataColumn10
			// 
			this.dataColumn10.ColumnName = "CC";
			// 
			// dataColumn11
			// 
			this.dataColumn11.ColumnName = "(S)atisfactory or (U)nsatisfactory";
			// 
			// dataSet1
			// 
			this.dataSet1.DataSetName = "NewDataSet";
			this.dataSet1.Locale = new System.Globalization.CultureInfo("en-US");
			this.dataSet1.Tables.AddRange(new System.Data.DataTable[] {
																		  this.dataTable1});
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(582, 496);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(0, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(40, 460);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(32, 36);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// tabResults
			// 
			this.tabResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabResults.Location = new System.Drawing.Point(4, 8);
			this.tabResults.Name = "tabResults";
			this.tabResults.SelectedIndex = 0;
			this.tabResults.Size = new System.Drawing.Size(694, 388);
			this.tabResults.TabIndex = 0;
			this.tabResults.SelectedIndexChanged += new System.EventHandler(this.tabResults_SelectedIndexChanged);
			// 
			// pnlGrid
			// 
			this.pnlGrid.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlGrid.Controls.Add(this.dgRack);
			this.pnlGrid.Location = new System.Drawing.Point(8, 40);
			this.pnlGrid.Name = "pnlGrid";
			this.pnlGrid.Size = new System.Drawing.Size(682, 350);
			this.pnlGrid.TabIndex = 1;
			// 
			// pnlQCTests
			// 
			this.pnlQCTests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlQCTests.Controls.Add(this.grpKey);
			this.pnlQCTests.Controls.Add(this.grpValidEntries);
			this.pnlQCTests.Controls.Add(this.pnlGrid);
			this.pnlQCTests.Controls.Add(this.tabResults);
			this.pnlQCTests.Location = new System.Drawing.Point(40, 28);
			this.pnlQCTests.Name = "pnlQCTests";
			this.pnlQCTests.Size = new System.Drawing.Size(702, 466);
			this.pnlQCTests.TabIndex = 0;
			// 
			// grpKey
			// 
			this.grpKey.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.grpKey.Controls.Add(this.lblErrorText);
			this.grpKey.Controls.Add(this.lblError);
			this.grpKey.Controls.Add(this.lblWarningText);
			this.grpKey.Controls.Add(this.lblValidText);
			this.grpKey.Controls.Add(this.lblWarning);
			this.grpKey.Controls.Add(this.lblValid);
			this.grpKey.Location = new System.Drawing.Point(4, 396);
			this.grpKey.Name = "grpKey";
			this.grpKey.Size = new System.Drawing.Size(116, 68);
			this.grpKey.TabIndex = 3;
			this.grpKey.TabStop = false;
			this.grpKey.Text = "Key";
			// 
			// lblErrorText
			// 
			this.lblErrorText.Location = new System.Drawing.Point(36, 48);
			this.lblErrorText.Name = "lblErrorText";
			this.lblErrorText.Size = new System.Drawing.Size(76, 16);
			this.lblErrorText.TabIndex = 5;
			this.lblErrorText.Text = "Unsatisfactory";
			// 
			// lblError
			// 
			this.lblError.BackColor = System.Drawing.Color.Red;
			this.lblError.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblError.CausesValidation = false;
			this.lblError.Location = new System.Drawing.Point(8, 48);
			this.lblError.Name = "lblError";
			this.lblError.Size = new System.Drawing.Size(16, 16);
			this.lblError.TabIndex = 4;
			this.lblError.Text = "U";
			this.lblError.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblWarningText
			// 
			this.lblWarningText.Location = new System.Drawing.Point(36, 32);
			this.lblWarningText.Name = "lblWarningText";
			this.lblWarningText.Size = new System.Drawing.Size(49, 16);
			this.lblWarningText.TabIndex = 3;
			this.lblWarningText.Text = "Warning";
			this.lblWarningText.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblValidText
			// 
			this.lblValidText.Location = new System.Drawing.Point(36, 16);
			this.lblValidText.Name = "lblValidText";
			this.lblValidText.Size = new System.Drawing.Size(68, 16);
			this.lblValidText.TabIndex = 2;
			this.lblValidText.Text = "Satisfactory";
			this.lblValidText.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWarning
			// 
			this.lblWarning.BackColor = System.Drawing.Color.Yellow;
			this.lblWarning.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblWarning.CausesValidation = false;
			this.lblWarning.Location = new System.Drawing.Point(8, 32);
			this.lblWarning.Name = "lblWarning";
			this.lblWarning.Size = new System.Drawing.Size(16, 16);
			this.lblWarning.TabIndex = 1;
			this.lblWarning.Text = "W";
			this.lblWarning.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblValid
			// 
			this.lblValid.BackColor = System.Drawing.Color.Lime;
			this.lblValid.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblValid.CausesValidation = false;
			this.lblValid.Location = new System.Drawing.Point(8, 16);
			this.lblValid.Name = "lblValid";
			this.lblValid.Size = new System.Drawing.Size(16, 16);
			this.lblValid.TabIndex = 0;
			this.lblValid.Text = "S";
			this.lblValid.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// grpValidEntries
			// 
			this.grpValidEntries.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpValidEntries.Controls.Add(this.lblValidEntries);
			this.grpValidEntries.Location = new System.Drawing.Point(124, 396);
			this.grpValidEntries.Name = "grpValidEntries";
			this.grpValidEntries.Size = new System.Drawing.Size(574, 68);
			this.grpValidEntries.TabIndex = 2;
			this.grpValidEntries.TabStop = false;
			this.grpValidEntries.Text = "Valid Entries";
			// 
			// lblValidEntries
			// 
			this.lblValidEntries.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblValidEntries.Location = new System.Drawing.Point(8, 20);
			this.lblValidEntries.Name = "lblValidEntries";
			this.lblValidEntries.Size = new System.Drawing.Size(558, 40);
			this.lblValidEntries.TabIndex = 0;
			this.lblValidEntries.Text = "0 = No Agglutination    M = Microscopic     W = Weak     1 = 1+    2 = 2+    3 = " +
				"3+    4 = 4+  ";
			// 
			// btnInvalidate
			// 
			this.btnInvalidate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnInvalidate.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnInvalidate.Image = null;
			this.btnInvalidate.Location = new System.Drawing.Point(138, 498);
			this.btnInvalidate.Name = "btnInvalidate";
			this.btnInvalidate.Size = new System.Drawing.Size(128, 23);
			this.btnInvalidate.TabIndex = 1;
			this.btnInvalidate.Click += new System.EventHandler(this.btnInvalidate_Click);
			// 
			// FrmDailyReagentRackQC
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(742, 523);
			this.Controls.Add(this.btnInvalidate);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.pnlQCTests);
			this.hlphelpChm.SetHelpKeyword(this, "Enter_Daily_QC_Results.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			
			this.MinimumSize = new System.Drawing.Size(750, 550);
			this.Name = "FrmDailyReagentRackQC";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Enter Daily QC Results";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmDailyReagentRackQC_Closing);
			this.VisibleChanged += new System.EventHandler(this.FrmDailyReagentRackQC_VisibleChanged);
			this.Activated += new System.EventHandler(this.FrmDailyReagentRackQC_Activated);
			this.Controls.SetChildIndex(this.pnlQCTests, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnInvalidate, 0);
			((System.ComponentModel.ISupportInitialize)(this.dgRack)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).EndInit();
			this.grpImage.ResumeLayout(false);
			this.pnlGrid.ResumeLayout(false);
			this.pnlQCTests.ResumeLayout(false);
			this.grpKey.ResumeLayout(false);
			this.grpValidEntries.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Creates number of tabpages equal to the number of racks tested
		/// </summary>
		private void InitializeCustomComponents()
		{
			int nNumberOfRacks = _dtRacks.Rows.Count;

			this.dataGridTextBoxColumn6 = new gov.va.med.vbecs.GUI.DataGridKeyTrapTextBoxColumn();
			this.dataGridTextBoxColumn7 = new gov.va.med.vbecs.GUI.DataGridKeyTrapTextBoxColumn();
			this.dataGridTextBoxColumn8 = new gov.va.med.vbecs.GUI.DataGridKeyTrapTextBoxColumn();

			// 
			// dataGridTextBoxColumn6
			// 
			this.dataGridTextBoxColumn6.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.dataGridTextBoxColumn6.Format = string.Empty;
			this.dataGridTextBoxColumn6.FormatInfo = null;
			this.dataGridTextBoxColumn6.HeaderText = "    IS*";
			this.dataGridTextBoxColumn6.MappingName = "IsResults";
			this.dataGridTextBoxColumn6.ProcessAcross = false;
			this.dataGridTextBoxColumn6.Width = 50;
			this.dataGridTextBoxColumn6.TextBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.dcTextKeyTrapCol_TextBoxKeyPress);
			this.dataGridTextBoxColumn6.TextBox.TextChanged += new EventHandler(dcTextKeyTrapCol_TextChanged);
			// 
			// dataGridTextBoxColumn7
			// 
			this.dataGridTextBoxColumn7.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.dataGridTextBoxColumn7.Format = string.Empty;
			this.dataGridTextBoxColumn7.FormatInfo = null;
			this.dataGridTextBoxColumn7.HeaderText = "   IAT*";
			this.dataGridTextBoxColumn7.MappingName = "IatResults";
			this.dataGridTextBoxColumn7.ProcessAcross = false;
			this.dataGridTextBoxColumn7.Width = 50;
			this.dataGridTextBoxColumn7.TextBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.dcTextKeyTrapCol_TextBoxKeyPress);
			this.dataGridTextBoxColumn7.TextBox.TextChanged += new EventHandler(dcTextKeyTrapCol_TextChanged);
			// 
			// dataGridTextBoxColumn8
			// 
			this.dataGridTextBoxColumn8.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.dataGridTextBoxColumn8.Format = string.Empty;
			this.dataGridTextBoxColumn8.FormatInfo = null;
			this.dataGridTextBoxColumn8.HeaderText = "    CC*";
			this.dataGridTextBoxColumn8.MappingName = "CCResults";
			this.dataGridTextBoxColumn8.ProcessAcross = false;
			this.dataGridTextBoxColumn8.Width = 50;
			this.dataGridTextBoxColumn8.TextBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.dcTextKeyTrapCol_TextBoxKeyPress);
			this.dataGridTextBoxColumn8.TextBox.TextChanged += new EventHandler(dcTextKeyTrapCol_TextChanged);

			this.dataGridTableStyle1.GridColumnStyles.AddRange(new System.Windows.Forms.DataGridColumnStyle[] {
																												  this.dataGridTextBoxColumn1,
																												  this.dataGridTextBoxColumn2,
																												  this.dataGridTextBoxColumn3,
																												  this.dataGridTextBoxColumn4,
																												  this.dataGridTextBoxColumn5,
																												  this.dataGridTextBoxColumn6,
																												  this.dataGridTextBoxColumn7,
																												  this.dataGridTextBoxColumn8,
																												  this.dataGridTextBoxColumn9,
																												  this.dataGridTextBoxColumn10,
																												  this.dataGridTextBoxColumn11,
																												  this.dataGridTextBoxColumn12,
																												  this.dataGridTextBoxColumn13,
																												  this.dataGridTextBoxColumn14,
																												  this.dataGridTextBoxColumn15});

			this.pageRacks = new System.Windows.Forms.TabPage[nNumberOfRacks];

			for (int i=0 ; i<nNumberOfRacks ; i++)
			{
				this.pageRacks[i] = new System.Windows.Forms.TabPage(_dtRacks.Rows[i]["RackName"].ToString());
				this.pageRacks[i].Tag = i;
				this.pageRacks[i].Location = new System.Drawing.Point(4, 23);
				this.pageRacks[i].Size = new System.Drawing.Size(488, 375);
				this.pageRacks[i].TabIndex = i;
			}

			this.tabResults.TabPages.AddRange(this.pageRacks);
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Daily QC - Enter Results";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC028.FrmDailyReagentRackQC());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = true;
			this.btnInvalidate.Text = "&Invalidate Test Results";
			dgRack.ToolTipColumn = 10;
			dgRack.LostFocus += new EventHandler(dgRack_LostFocus);
		}

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/23/2002</CreationDate>
		///
		/// <summary>
		/// Creates a hash table of testing results.
		/// </summary>
		private void InitializeLookup()
		{
			// Fill hashtable with the valid values of each test result
			resultLookup = new Hashtable();

			resultLookup.Add("0", 0);
			resultLookup.Add("M", 1);
			resultLookup.Add("W", 2);
			resultLookup.Add("1", 3);
			resultLookup.Add("2", 4);
			resultLookup.Add("3", 5);
			resultLookup.Add("4", 6);
			//added this value for CR 1889 to accomodate for the situation where there is no previous result
			//but the user enters 0 with MinTest result > 0 which should also trigger Decrease in Reactivity exception
			resultLookup.Add("", 0);

		}

		private void LoadRackTestResults()
		{
			int nNumberOfRacks = _dtRacks.Rows.Count;
			int nCount = 0;
			_dtRackTestResults = new DataTable[nNumberOfRacks];

			for(int rackNumber=0 ; rackNumber<nNumberOfRacks ; rackNumber++)
			{

				_dtRackTestResults[rackNumber] = new DataTable();
				_dtRackTestResults[rackNumber].Columns.Add("ReagentGuid", typeof(Guid));
				_dtRackTestResults[rackNumber].Columns.Add("ReagentTypeName");
				_dtRackTestResults[rackNumber].Columns.Add(Common.VbecsTables.ReagentTestParameter.SetVialId);
				_dtRackTestResults[rackNumber].Columns.Add("TestWithName");
				_dtRackTestResults[rackNumber].Columns.Add("ExpectedMinimumReactions");
				_dtRackTestResults[rackNumber].Columns.Add("IsResults");
				_dtRackTestResults[rackNumber].Columns.Add("IatResults");
				_dtRackTestResults[rackNumber].Columns.Add("CcResults");
				_dtRackTestResults[rackNumber].Columns.Add("ReactivityPhaseText");
				_dtRackTestResults[rackNumber].Columns.Add("ReactivityPhaseCode");
				_dtRackTestResults[rackNumber].Columns.Add("IsGuid", typeof(Guid));
				_dtRackTestResults[rackNumber].Columns.Add("IsRowVersion", typeof(byte[]));
				_dtRackTestResults[rackNumber].Columns.Add("IatGuid", typeof(Guid));
				_dtRackTestResults[rackNumber].Columns.Add("IatRowVersion", typeof(byte[]));
				_dtRackTestResults[rackNumber].Columns.Add("CcGuid", typeof(Guid));
				_dtRackTestResults[rackNumber].Columns.Add("CcRowVersion", typeof(byte[]));
				_dtRackTestResults[rackNumber].Columns.Add("TestResultIndicator");
				_dtRackTestResults[rackNumber].Columns.Add("ReagentTypeId");
				_dtRackTestResults[rackNumber].Columns.Add("ReadOnlyIsResults", typeof(Boolean));
				_dtRackTestResults[rackNumber].Columns.Add("ReadOnlyIatResults", typeof(Boolean));
				_dtRackTestResults[rackNumber].Columns.Add("ReadOnlyCcResults", typeof(Boolean));
				_dtRackTestResults[rackNumber].Columns.Add(ARTIFICIAL.IndicatorMessage);
				_dtRackTestResults[rackNumber].Columns.Add("TestWithReagent", typeof(bool));
				_dtRackTestResults[rackNumber].Columns.Add("TestWithId", typeof(int));
				_dtRackTestResults[rackNumber].Columns.Add("ReagentExpiredException", typeof(BOL.ExceptionReport));
				_dtRackTestResults[rackNumber].Columns.Add("DecreaseInReactivityISException", typeof(BOL.ExceptionReport));
				_dtRackTestResults[rackNumber].Columns.Add("DecreaseInReactivityIATException", typeof(BOL.ExceptionReport));
				_dtRackTestResults[rackNumber].Columns.Add("DecreaseInReactivityCCException", typeof(BOL.ExceptionReport));
				_dtRackTestResults[rackNumber].Columns.Add(Common.VbecsTables.RackLot.TestingMethodCode);
				_dtRackTestResults[rackNumber].Columns.Add("Insert", typeof(bool));
				_dtRackTestResults[rackNumber].Columns.Add(Common.VbecsTables.RackTest.TestWithReagentGuid, typeof(Guid));
				nCount = _dtLotNumbers[rackNumber].Rows.Count ;
				for(int rowNumber=0 ; rowNumber<nCount ; rowNumber++)
				{
					SetUpRackTestRow(rackNumber, rowNumber);
				}
			}

			dgRack.DataSource = _dtRackTestResults[0].DefaultView;
			((DataView)dgRack.DataSource).AllowDelete = false;
			((DataView)dgRack.DataSource).AllowNew = false;
			((DataView)dgRack.DataSource).RowFilter = "TestWithReagent = 0";

			if (IsRackFilled() == true &&
				this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) == false)
			{
				this.btnOK.Hide();
				dgRack.Enabled = false;
				this.btnInvalidate.EnabledButton = false;
			}
			else
			{
				this.btnOK.Show();
				dgRack.Enabled = true;
				this.btnInvalidate.EnabledButton = true;
			}


		}

		/// <summary>
		/// Sets up the data grid row based on the lot number from dtLotNumbersTable
		/// This method is being called when loading this screen and from RecordLotNumbers screen 
		/// when user decides to change lot number for tested reagent type
		/// </summary>
		/// <param name="rackNumber"></param>
		/// <param name="rowNumber"></param>
		public void SetUpRackTestRow(int rackNumber, int rowNumber)
		{
			DataTable dtPreviousTestResults;
			DataRow drRackTest;
			DataRow[] drPreviousTestResult;
			Guid dailyQcWorklistGuid = Guid.Empty;
			//			DataRow[] drAffectedTestResults;
			//			int nRow;

			DataRow drLot = _dtLotNumbers[rackNumber].Rows[rowNumber];

			//the row does not exist yet - create
			if (_dtRackTestResults[rackNumber].Rows.Count <= rowNumber)
			{
				drRackTest = _dtRackTestResults[rackNumber].NewRow();
			}
			else
			{
				drRackTest = _dtRackTestResults[rackNumber].Rows[rowNumber];
			}

			try
			{
				if (this._dtRacks.Rows[rackNumber].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid) == false)
					dailyQcWorklistGuid = (Guid)this._dtRacks.Rows[rackNumber][Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid];
				dtPreviousTestResults = BOL.RackTest.GetRackTestResult((Guid)drLot["ReagentGuid"], (Guid)_dtRacks.Rows[rackNumber][Common.VbecsTables.Rack.RackGuid], dailyQcWorklistGuid);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				dtPreviousTestResults = new DataTable();
			}

			//CR 2696 - find out which reagent is used as TestWith reagent for the current testing row
			DataRow[] testWithReagents = new DataRow[0];
			testWithReagents = _dtLotNumbers[rackNumber].Select(Common.VbecsTables.Reagent.ReagentTypeId + " = '" + drLot[Common.VbecsTables.RackLot.TestWithId].ToString() + "'");

			if (testWithReagents.Length > 0)
			{
				Guid testWithReagentGuid = (Guid)testWithReagents[0][Common.VbecsTables.Reagent.ReagentGuid];
				if (drLot.IsNull(Common.VbecsTables.ReagentTestParameter.SetVialId))
				{
					drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "' AND TestWithReagentGuid = '" + testWithReagentGuid.ToString() + "'", "LastUpdateDate DESC");
				}
				else
				{
					if (drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == string.Empty)
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "' AND TestWithReagentGuid = '" + testWithReagentGuid.ToString() + "'", "LastUpdateDate DESC");
					}
					else
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "' AND LotVialNumber = '" + drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString() + "' AND TestWithReagentGuid = '" + testWithReagentGuid.ToString() + "'", "LastUpdateDate DESC");
					}
				}
			}
			else
			{
				if (drLot.IsNull(Common.VbecsTables.ReagentTestParameter.SetVialId))
				{
					drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'", "LastUpdateDate DESC");
				}
				else
				{
					if (drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == string.Empty)
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'", "LastUpdateDate DESC");
					}
					else
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "' AND LotVialNumber = '" + drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString() + "'", "LastUpdateDate DESC");
					}
				}
			}

			//if result for this lot already exists
			if (drPreviousTestResult.Length > 0)
			{
				drRackTest["ReagentGuid"] = drLot["ReagentGuid"];
				if (drLot.IsNull(Common.VbecsTables.ReagentTestParameter.SetVialId))
				{
					drRackTest["ReagentTypeName"] = drLot["ReagentTypeForQCTemplate"];
				}
				else
				{
					if (drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == string.Empty ||
						drLot["ReagentTypeForQCTemplate"].ToString().Trim() == "A1 Cell" ||
						drLot["ReagentTypeForQCTemplate"].ToString().Trim() == "B Cell")
					{
						drRackTest["ReagentTypeName"] = drLot["ReagentTypeForQCTemplate"];
					}
					else
					{
						drRackTest["ReagentTypeName"] = drLot["ReagentTypeForQCTemplate"].ToString() + " " + drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString();
					}
				}
				drRackTest[Common.VbecsTables.ReagentTestParameter.SetVialId] = drLot[Common.VbecsTables.ReagentTestParameter.SetVialId];
				drRackTest["TestWithName"] = drPreviousTestResult[0]["TestWithName"];
				drRackTest["TestWithId"] = drPreviousTestResult[0]["TestWithId"];
				drRackTest["ExpectedMinimumReactions"] = drPreviousTestResult[0]["ExpectedMinimumReactions"];
				drRackTest["ReactivityPhaseText"] = drPreviousTestResult[0]["ReactivityPhaseText"];
				drRackTest["ReactivityPhaseCode"] = drPreviousTestResult[0]["ReactivityPhaseCode"];
				//CR 2696
				drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid] = drPreviousTestResult[0][Common.VbecsTables.RackTest.TestWithReagentGuid];

				drRackTest["IsResults"] = string.Empty;
				drRackTest["IatResults"] = string.Empty;
				drRackTest["CcResults"] = string.Empty;

				//CR 2696 - added check for TestWithReagentGuid to all Select statements
				//IS
				if (drLot.IsNull(Common.VbecsTables.ReagentTestParameter.SetVialId))
				{
					drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'IS' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
				}
				else
				{
					if (drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == string.Empty)
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'IS' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
					}
					else
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'IS' AND LotVialNumber = '" + drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString() + "' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
					}
				}

				if (drPreviousTestResult.Length > 0)
				{
					if (drPreviousTestResult[0].IsNull("RackTestResult"))
					{
						drRackTest["IsResults"] = string.Empty;
					}
					else
					{
						drRackTest["IsResults"] = drPreviousTestResult[0]["RackTestResult"];
					}
					drRackTest["IsGuid"] = drPreviousTestResult[0][Common.VbecsTables.RackTest.RackTestGuid];
					drRackTest["IsRowVersion"] = drPreviousTestResult[0][Common.VbecsTables.RackTest.RowVersion];
				}

				//IAT
				if (drLot.IsNull(Common.VbecsTables.ReagentTestParameter.SetVialId))
				{
					drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'IAT' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
				}
				else
				{
					if (drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == string.Empty)
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'IAT' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
					}
					else
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'IAT' AND LotVialNumber = '" + drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString() + "' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
					}
				}

				if (drPreviousTestResult.Length > 0)
				{
					if (drPreviousTestResult[0].IsNull("RackTestResult"))
					{
						drRackTest["IatResults"] = string.Empty;
					}
					else
					{
						drRackTest["IatResults"] = drPreviousTestResult[0]["RackTestResult"];
					}
					drRackTest["IatGuid"] = drPreviousTestResult[0][Common.VbecsTables.RackTest.RackTestGuid];
					drRackTest["IatRowVersion"] = drPreviousTestResult[0][Common.VbecsTables.RackTest.RowVersion];
				}

				//CC
				if (drLot.IsNull(Common.VbecsTables.ReagentTestParameter.SetVialId))
				{
					drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'CC' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
				}
				else
				{
					if (drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == string.Empty)
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'CC' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
					}
					else
					{
						drPreviousTestResult = dtPreviousTestResults.Select("ReagentGuid = '" + drLot[Common.VbecsTables.RackLot.ReagentGuid].ToString() + "' AND TestWithName='" + drLot["TestWithName"].ToString() + "' AND ReactivityPhaseCode = '" + drLot["ReactivityPhaseCode"].ToString() + "'" + " AND RackTestResultTypeCode = 'CC' AND LotVialNumber = '" + drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString() + "' AND TestWithReagentGuid = '" + drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid].ToString() + "'", "LastUpdateDate DESC");
					}
				}

				if (drPreviousTestResult.Length > 0)
				{
					if (drPreviousTestResult[0].IsNull("RackTestResult"))
					{
						drRackTest["CcResults"] = string.Empty;
					}
					else
					{
						drRackTest["CcResults"] = drPreviousTestResult[0]["RackTestResult"];
					}
					drRackTest["CcGuid"] = drPreviousTestResult[0][Common.VbecsTables.RackTest.RackTestGuid];
					drRackTest["CcRowVersion"] = drPreviousTestResult[0][Common.VbecsTables.RackTest.RowVersion];
				}
				//				}

				drRackTest["ReagentTypeId"] = drLot["ReagentTypeIDForQCTemplate"];
				drRackTest["ReadOnlyIsResults"] = drRackTest["IsResults"].ToString().Equals(String.Empty) ? false : true;
				drRackTest["ReadOnlyIatResults"] = drRackTest["IatResults"].ToString().Equals(String.Empty) ? false : true;
				drRackTest["ReadOnlyCcResults"] = drRackTest["CcResults"].ToString().Equals(String.Empty) ? false : true;
				drRackTest[ARTIFICIAL.IndicatorMessage] = string.Empty;
				drRackTest["TestWithReagent"] = drLot["TestWithReagent"];
				if (drLot[Common.VbecsTables.TestingMethod.TestingMethodText].ToString().Trim() != string.Empty)
					drRackTest[Common.VbecsTables.RackLot.TestingMethodCode] = drLot[Common.VbecsTables.TestingMethod.TestingMethodText].ToString().Substring(0, 1);
				else
					drRackTest[Common.VbecsTables.RackLot.TestingMethodCode] = drLot[Common.VbecsTables.TestingMethod.TestingMethodText].ToString();
				drRackTest["Insert"] = drLot["Insert"];
			}
			else
			{
				drRackTest["ReagentGuid"] = drLot["ReagentGuid"];
				if (drLot.IsNull(Common.VbecsTables.ReagentTestParameter.SetVialId))
				{
					drRackTest["ReagentTypeName"] = drLot["ReagentTypeForQCTemplate"];
				}
				else
				{
					if (drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == string.Empty ||
						drLot["ReagentTypeForQCTemplate"].ToString().Trim() == "A1 Cell" ||
						drLot["ReagentTypeForQCTemplate"].ToString().Trim() == "B Cell")
					{
						drRackTest["ReagentTypeName"] = drLot["ReagentTypeForQCTemplate"];
					}
					else
					{
						drRackTest["ReagentTypeName"] = drLot["ReagentTypeForQCTemplate"].ToString() + " " + drLot[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString();
					}
				}
				drRackTest[Common.VbecsTables.ReagentTestParameter.SetVialId] = drLot[Common.VbecsTables.ReagentTestParameter.SetVialId];
				drRackTest["TestWithName"] = drLot["TestWithName"];
				drRackTest["TestWithId"] = drLot["TestWithId"];
				drRackTest["ExpectedMinimumReactions"] = drLot["ExpectedMinimumReactions"];
				drRackTest["ReactivityPhaseText"] = drLot["ReactivityPhaseText"];
				drRackTest["ReactivityPhaseCode"] = drLot["ReactivityPhaseCode"];
				drRackTest["IsResults"] = string.Empty;
				drRackTest["IsGuid"] = DBNull.Value;
				drRackTest["IsRowVersion"] = DBNull.Value;
				drRackTest["IatResults"] = string.Empty;
				drRackTest["IatGuid"] = DBNull.Value;
				drRackTest["IatRowVersion"] = DBNull.Value;
				drRackTest["CcResults"] = string.Empty;
				drRackTest["CcGuid"] = DBNull.Value;
				drRackTest["CcRowVersion"] = DBNull.Value;
				drRackTest["TestResultIndicator"] = string.Empty;
				drRackTest["ReagentTypeId"] = drLot["ReagentTypeIDForQCTemplate"];
				drRackTest["ReadOnlyIsResults"] = false;
				drRackTest["ReadOnlyIatResults"] = false;
				drRackTest["ReadOnlyCcResults"] = false;
				drRackTest[ARTIFICIAL.IndicatorMessage] = string.Empty;
				drRackTest["TestWithReagent"] = drLot["TestWithReagent"];
				drRackTest["Insert"] = drLot["Insert"];
				if (drLot[Common.VbecsTables.TestingMethod.TestingMethodText].ToString().Trim() != string.Empty)
					drRackTest[Common.VbecsTables.RackLot.TestingMethodCode] = drLot[Common.VbecsTables.TestingMethod.TestingMethodText].ToString().Substring(0, 1);
				else
					drRackTest[Common.VbecsTables.RackLot.TestingMethodCode] = drLot[Common.VbecsTables.TestingMethod.TestingMethodText].ToString();
				
				//CR 2696 find the TestWithReagentGuid for the current row
				testWithReagents = new DataRow[0];
				testWithReagents = _dtLotNumbers[rackNumber].Select(Common.VbecsTables.Reagent.ReagentTypeId + " = '" + drLot[Common.VbecsTables.RackLot.TestWithId].ToString() + "'");

				if (testWithReagents.Length > 0)
				{
					drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid] = (Guid)testWithReagents[0][Common.VbecsTables.Reagent.ReagentGuid];
				}
			}

			//			if (cleanTestResults == true)
			//			{
			//				drAffectedTestResults = _dtRackTestResults[rackNumber].Select("TestWithId=" + drLot["ReagentTypeIDForQCTemplate"].ToString());
			//				if (drAffectedTestResults.Length > 0)
			//				{
			//					foreach(DataRow drAffectedRackTest in drAffectedTestResults)
			//					{
			//						for (nRow = 0; nRow < this._dtLotNumbers[this._nActiveRack].Rows.Count; nRow++)
			//						{
			//							if (_dtRackTestResults[rackNumber].Rows[nRow].Equals(drAffectedRackTest))
			//								break;
			//						}
			//						SetUpRackTestRow(rackNumber, nRow, true);
			//					}
			//				}
			//			}

			//the row does not exist yet - add
			if (_dtRackTestResults[rackNumber].Rows.Count <= rowNumber)
			{
				_dtRackTestResults[rackNumber].Rows.Add(drRackTest);
			}

			UpdateIndicator(rowNumber, rackNumber);
			if (IsRackFilled() == true &&
				this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) == false)
			{
				this.btnOK.Hide();
				dgRack.Enabled = false;
				this.btnInvalidate.EnabledButton = false;
			}
			else
			{
				this.btnOK.Show();
				dgRack.Enabled = true;
				this.btnInvalidate.EnabledButton = true;
			}
		}

		/// <summary>
		/// Updates the testing method code
		/// </summary>
		/// <param name="rackNumber"></param>
		/// <param name="rowNumber"></param>
		/// <param name="testingMethodCode"></param>
		public void UpdateTestingMethod(int rackNumber, int rowNumber, string testingMethodCode)
		{
			DataRow drRackTest = _dtRackTestResults[rackNumber].Rows[rowNumber];
			drRackTest[Common.VbecsTables.RackLot.TestingMethodCode] = testingMethodCode;
		}

		/// <summary>
		/// Checks if the user entered at least one test result for the current rack
		/// </summary>
		/// <returns></returns>
		private bool IsRackReadyToSave(int rack)
		{
			if (IsRackFilled() == true &&
				this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) == false)
			{
				this.btnOK.Hide();
				dgRack.Enabled = false;
				this.btnInvalidate.EnabledButton = false;
			}
			else
			{
				this.btnOK.Show();
				dgRack.Enabled = true;
				this.btnInvalidate.EnabledButton = true;
				if (IsRackEmpty() == true)
				{
					this.btnInvalidate.EnabledButton = false;
					return false;
				}
				else
				{
					this.btnInvalidate.EnabledButton = true;
				}
			}

			foreach(DataRow drRackTest in this._dtRackTestResults[rack].Rows)
			{
				if ((bool)drRackTest["TestWithReagent"] == false)
				{
					if (drRackTest["TestResultIndicator"].ToString().Trim() == "U")
					{
						return false;
					}
				}
			}

			foreach(DataRow drRackTest in this._dtRackTestResults[rack].Rows)
			{
				if ((bool)drRackTest["TestWithReagent"] == false)
				{
					if ((bool)drRackTest["ReadOnlyIsResults"] == false &&
						drRackTest["IsResults"].ToString().Trim() != string.Empty)
						return true;
					if ((bool)drRackTest["ReadOnlyIatResults"] == false &&
						drRackTest["IatResults"].ToString().Trim() != string.Empty)
						return true;
					if ((bool)drRackTest["ReadOnlyCcResults"] == false &&
						drRackTest["CcResults"].ToString().Trim() != string.Empty)
						return true;
				}
			}

			return false;
		}

		/// <summary>
		/// Checks if all results are satisfactory
		/// </summary>
		/// <returns></returns>
		private bool IsRackFullyTested()
		{
			foreach(DataRow drRackTest in this._dtRackTestResults[this._nActiveRack].Rows)
			{
				if ((bool)drRackTest["TestWithReagent"] == false)
				{
					if (drRackTest["TestResultIndicator"].ToString().ToUpper().Trim() == "U" ||
						drRackTest["TestResultIndicator"].ToString().ToUpper().Trim() == string.Empty)
					{
						return false;
					}
				}
			}

			return true;
		}

		/// <summary>
		/// Checks if current rack has all test results filled and saved
		/// </summary>
		/// <returns></returns>
		private bool IsRackFilled()
		{
			bool IsResultFilled;
			bool IatResultFilled;
			bool CcResultFilled;

			foreach(DataRow drRackTest in this._dtRackTestResults[this._nActiveRack].Rows)
			{
				if ((bool)drRackTest["TestWithReagent"] == false)
				{
					if ((bool)drRackTest["ReadOnlyIsResults"] == false &&
						/*drRackTest["IsResults"].ToString().Trim() == string.Empty &&*/
						drRackTest["ReactivityPhaseText"].ToString().Trim() == "IS")
					{
						IsResultFilled = false;
					}
					else
					{
						IsResultFilled = true;
					}

					if ((bool)drRackTest["ReadOnlyIatResults"] == false &&
						/*drRackTest["IatResults"].ToString().Trim() == string.Empty &&*/
						(drRackTest["ReactivityPhaseText"].ToString().Trim() == "IAT" ||
						drRackTest["ReactivityPhaseText"].ToString().Trim() == "IS/IAT"))
					{
						IatResultFilled = false;
					}
					else
					{
						IatResultFilled = true;
					}

					if ((bool)drRackTest["ReadOnlyIatResults"] == false &&
						/*drRackTest["CcResults"].ToString().Trim() == string.Empty &&*/
						(drRackTest["ReactivityPhaseText"].ToString().Trim() == "IAT" ||
						drRackTest["ReactivityPhaseText"].ToString().Trim() == "IS/IAT") &&
						drRackTest["ExpectedMinimumReactions"].ToString().Trim() == "0")
					{
						CcResultFilled = false;
					}
					else
					{
						CcResultFilled = true;
					}

					if (IsResultFilled == false || IatResultFilled == false || CcResultFilled == false)
					{
						return false;
					}
				}
			}

			return true;
		}

		/// <summary>
		/// Check if the rack has no test results
		/// </summary>
		/// <returns></returns>
		private bool IsRackEmpty()
		{
			foreach(DataRow drRackTest in this._dtRackTestResults[this._nActiveRack].Rows)
			{
				if ((bool)drRackTest["TestWithReagent"] == false)
				{
					if (drRackTest.IsNull("IsResults") == false)
					{
						if (drRackTest["IsResults"].ToString().Trim() != string.Empty)
							return false;
					}
					if (drRackTest.IsNull("IatResults") == false)
					{
						if (drRackTest["IatResults"].ToString().Trim() != string.Empty)
							return false;
					}
					if (drRackTest.IsNull("CcResults") == false)
					{
						if (drRackTest["CcResults"].ToString().Trim() != string.Empty)
							return false;
					}
				}
			}

			return true;
		}

		/// <summary>
		/// Sets the foucs on the first editable cell
		/// </summary>
		public void FocusOnTheFirstEditableCell()
		{
			_RowCount = this._dtRackTestResults[_nActiveRack].Select("TestWithReagent = 0").Length;

			if (IsRackFilled() &&
				this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) == false)
			{
				dgRack.SetNoCurrentCell();
				dgRack.Enabled = false;
			}
			else
			{
				this.dgRack.CurrentCell = new DataGridCell(0, 5);
				dgRack.Enabled = true;
			}
		}

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/28/2003</CreationDate>
		///
		/// <summary>
		///  Sets the next valid cell and updates the row indicator message.
		/// </summary>
		private void SetNextCell()
		{
			int currentRow = dgRack.CurrentCell.RowNumber;

			if (dgRack.CurrentCell.RowNumber + 1 < _RowCount)
			{
				dgRack.CurrentCell = new DataGridCell(dgRack.CurrentCell.RowNumber + 1, dgRack.CurrentCell.ColumnNumber);
			}
			else if (dgRack.CurrentCell.ColumnNumber < _RightHiddenColumn)
			{
				dgRack.CurrentCell = new DataGridCell(0, dgRack.CurrentCell.ColumnNumber + 1);
			}
			else
			{
				if(_lastValidRow != 0 && _lastValidColumn != 0)
				{
					if (_lastValidRow + 1 == _RowCount && _lastValidColumn == 7)
					{
						dgRack.CurrentCell = new DataGridCell(_lastValidRow - 1, _lastValidColumn);
						dgRack.CurrentCell = new DataGridCell(_lastValidRow, _lastValidColumn);
					}
					else
					{
						dgRack.CurrentCell = new DataGridCell(_lastValidRow, _lastValidColumn);
					}
				}
				else
				{
					dgRack.CurrentCell = new DataGridCell(0, 0);
				}
			}
		}

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/23/2003</CreationDate>
		///
		/// <summary>
		/// Updates the row indicator to indicate the status of the test results.
		/// </summary>
		/// <param name="row"></param>
		/// <param name="nRack"></param>
		private void UpdateIndicator(int row, int nRack)
		{
			string minimumResult = this._dtRackTestResults[nRack].Rows[row]["ExpectedMinimumReactions"].ToString().Trim();	// minimum result
			string isResults = this._dtRackTestResults[nRack].Rows[row]["IsResults"].ToString().Trim();		// ISResults
			string iatResults = this._dtRackTestResults[nRack].Rows[row]["IatResults"].ToString().Trim();		// IATResults
			string ccResults = this._dtRackTestResults[nRack].Rows[row]["CcResults"].ToString().Trim();		// CCResults
			string testPhase = this._dtRackTestResults[nRack].Rows[row]["ReactivityPhaseText"].ToString().Trim();		// test phase code
			string reagentTypeId = this._dtRackTestResults[nRack].Rows[row]["ExpectedMinimumReactions"].ToString().Trim();	// reagent type id

			RowIndicator rowStatus = RowIndicator.Empty;


			isResults = isResults == null ? string.Empty : isResults;
			iatResults = iatResults == null ? string.Empty : iatResults;
			ccResults = ccResults == null ? string.Empty : ccResults;
				
			if (isResults == string.Empty && iatResults == string.Empty && ccResults == string.Empty)
			{
				// Empty tests and results, remove indicator
				_dtRackTestResults[nRack].Rows[row]["TestResultIndicator"] = string.Empty;
				return;
			}
			
			if (testPhase == "IS")  // IS test phase
			{
				if (isResults == string.Empty)
				{
					rowStatus = RowIndicator.Error;
				}
				else if (minimumResult == "0" && isResults != "0")
				{
					rowStatus = RowIndicator.Warning;
				}
				else if ((int) resultLookup[minimumResult] > (int) resultLookup[isResults])
				{
					rowStatus = RowIndicator.Warning;
				}
				else
				{
					rowStatus = RowIndicator.Valid;
				}
			}
			else if (testPhase == "IAT")  // IAT test phase
			{
				if (iatResults == string.Empty)
				{
					rowStatus = RowIndicator.Error;
				}
				else if (minimumResult == "0")  
				{
					if (ccResults == string.Empty && iatResults == "0")
					{
						rowStatus = RowIndicator.Error;
					}
					else if (iatResults == "0" && ((int) resultLookup[ccResults] > (int) resultLookup["M"]))
					{
						rowStatus = RowIndicator.Valid;
					}
					else
					{
						rowStatus = RowIndicator.Warning;
					}
				}
				else if ((int) resultLookup[minimumResult] > (int) resultLookup[iatResults])
				{
					rowStatus = RowIndicator.Warning;
				}
				else
				{
					rowStatus = RowIndicator.Valid;
				}			
			}
			else if (testPhase == "IS/IAT")  // IS/IAT test phase
			{
				if (isResults == string.Empty || iatResults == string.Empty || (ccResults == string.Empty && minimumResult == "0" && iatResults == "0"))
				{
					rowStatus = RowIndicator.Error;
				}
				else if (minimumResult == "0")  
				{
					if (ccResults == string.Empty && iatResults == "0")
					{
						rowStatus = RowIndicator.Error;
					}
					else if (isResults == "0" && iatResults == "0" && ((int) resultLookup[ccResults] > (int) resultLookup["M"]))
					{
						rowStatus = RowIndicator.Valid;
					}
					else
					{
						rowStatus = RowIndicator.Warning;
					}
				}
				else if ((int) resultLookup[minimumResult] > (int) resultLookup[iatResults] || (int) resultLookup[minimumResult] > (int) resultLookup[isResults])
				{
					rowStatus = RowIndicator.Warning;
				}
				else
				{
					rowStatus = RowIndicator.Valid;
				}
			}

			if (rowStatus == RowIndicator.Error)
			{
				_dtRackTestResults[nRack].Rows[row]["TestResultIndicator"] = "U"; 
				_dtRackTestResults[nRack].Rows[row][ARTIFICIAL.IndicatorMessage] = "Invalid entry, reagent must be tested. No override.";
			}
			else if (rowStatus == RowIndicator.Warning)
			{
				_dtRackTestResults[nRack].Rows[row]["TestResultIndicator"] = "W"; 
				_dtRackTestResults[nRack].Rows[row][ARTIFICIAL.IndicatorMessage] = "Invalid entry. Reagent is not reacting within expected parameters. Retest and/or remove from use if reaction valid.";
			}
			else 
			{
				_dtRackTestResults[nRack].Rows[row]["TestResultIndicator"] = "S"; 
				_dtRackTestResults[nRack].Rows[row][ARTIFICIAL.IndicatorMessage] = "Valid entry.";
			}
		}

		private void tabResults_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this._nActiveRack = (int)((System.Windows.Forms.TabControl)sender).SelectedTab.Tag;
			dgRack.DataSource = _dtRackTestResults[_nActiveRack].DefaultView;
			((DataView)dgRack.DataSource).AllowDelete = false;
			((DataView)dgRack.DataSource).AllowNew = false;
			((DataView)dgRack.DataSource).RowFilter = "TestWithReagent = 0";
			_RowCount = this._dtRackTestResults[_nActiveRack].Select("TestWithReagent = 0").Length;

			if (IsRackFilled() == true &&
				this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) == false)
			{
				this.btnOK.Hide();
				dgRack.Enabled = false;
				this.btnInvalidate.EnabledButton = false;
			}
			else
			{
				this.btnOK.Show();
				dgRack.Enabled = true;
				this.btnInvalidate.EnabledButton = true;
				this._lastValidColumn = 0;
				this._lastValidRow = 0;
				FocusOnTheFirstEditableCell();
				
				if (IsRackEmpty() == true)
				{
					this.btnInvalidate.EnabledButton = false;
				}
				else
				{
					this.btnInvalidate.EnabledButton = true;
				}
			}

		}

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// BR_2.28
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dcTextKeyTrapCol_TextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			string cellText = string.Empty;
			string cellTextFuture = string.Empty;
			string keyChar = string.Empty;
			string regPattern = string.Empty;
			int row = dgRack.CurrentCell.RowNumber;
			int column = dgRack.CurrentCell.ColumnNumber;
			string minimumResult = dgRack[row, 3].ToString().Trim();	// minimum result
			string sPreviousTestResult = string.Empty;

			
			TextBox c = (TextBox) sender;

			cellText = c.Text;

			// Indicator and hidden columns are not editable
			if (column < _LeftHiddenColumn || column > _RightHiddenColumn)
			{
				e.Handled = true;
				return;
			}
			
			// Let backspace and enter keys bypass
			if (!char.IsLetterOrDigit(e.KeyChar))
			{
				if (e.KeyChar == (int) Keys.Enter)
				{
					SetNextCell();
					e.Handled = true;
				}
				else
				{
					e.Handled = !char.IsControl(e.KeyChar);
				}
				return;
			}
			
			// Turn single character to upper
			keyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

			// Obtain what the string will look like after key is pressed
			if (cellText.Length > 0)
			{
				cellTextFuture = cellText.Substring(0, c.SelectionStart) + keyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
			}
			else
			{
				cellTextFuture = keyChar;
			}

			// Test what type of column it is and then apply the regular expression
			regPattern = @"(\A[WM01234]\z)";


			if (Regex.IsMatch(cellTextFuture, regPattern))
			{
				//changing values in the datable causes TextChanged event to be fired
				//setting a flag to prevent it from happening
				this._keyPressEventHandled = true;
				
				try
				{
					//compare current result to the previous test result and check for decrease in reactivity
					if (column == 5)
					{
						sPreviousTestResult = BOL.RackTest.GetPreviousRackTestResult((Guid)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReagentGuid"], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], (int)this._dtRackTestResults[this._nActiveRack].Rows[row]["TestWithId"], this._dtRackTestResults[this._nActiveRack].Rows[row]["TestWithName"].ToString().Trim(), "IS", this._testDateTime);
					}
					else if (column == 6)
					{
						sPreviousTestResult = BOL.RackTest.GetPreviousRackTestResult((Guid)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReagentGuid"], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], (int)this._dtRackTestResults[this._nActiveRack].Rows[row]["TestWithId"], this._dtRackTestResults[this._nActiveRack].Rows[row]["TestWithName"].ToString().Trim(), "IAT", this._testDateTime);
					}
					else if (column == 7)
					{
						sPreviousTestResult = BOL.RackTest.GetPreviousRackTestResult((Guid)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReagentGuid"], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], (int)this._dtRackTestResults[this._nActiveRack].Rows[row]["TestWithId"], this._dtRackTestResults[this._nActiveRack].Rows[row]["TestWithName"].ToString().Trim(), "CC", this._testDateTime);
					}

					if ((int)resultLookup[sPreviousTestResult] - (int) resultLookup[cellTextFuture] >= 2 ||
						(minimumResult != "0" && (int)resultLookup[cellTextFuture] == 0) ||
						(minimumResult == "0" && (int)resultLookup[cellTextFuture] != 0 && column != 7)) //CR 3159
					{
						c.Text = cellTextFuture;
						DataTable dtSource = ((DataView)dgRack.DataSource).Table;
						dtSource.Rows[row][column] = cellTextFuture;

						DialogResult previousTestResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC028.DecreaseInReagentReactivity());
						if (previousTestResult == DialogResult.No)
						{
							c.Text = string.Empty;
							((FrmRecordLotNumbers)this.Tag).Enabled = true;
							this.Hide();
							e.Handled = true;
							return;
						}
						else
						{
							DlgOverrideComment dlg = new DlgOverrideComment("Decrease in reagent reactivity", "Decrease in reagent reactivity of 2 or more. Enter a comment to continue to use this vial.", "RS");

                            dlg.ShowDialogFromLockedParent(this, false);
                            if (dlg.DialogResult == DialogResult.OK)    //TODO: Check for Abort(lockexpired)?
							{

								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.QC_decrease_reagent_reactivity, dlg.Comment, Common.LogonUser.LogonUserName);
								if (column == 5)
								{
                                    //CR 3298
									exRep.GenerateExceptionQC((Guid)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReagentGuid"], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], Guid.Empty, Guid.Empty, sPreviousTestResult, cellTextFuture, "IS", this._testingTech);
									this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityISException"] = exRep;
								}
								else if (column == 6)
								{
                                    //CR 3298
                                    exRep.GenerateExceptionQC((Guid)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReagentGuid"], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], Guid.Empty, Guid.Empty, sPreviousTestResult, cellTextFuture, "IAT", this._testingTech);
									this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityIATException"] = exRep;
								}
								else if (column == 7)
								{
                                    //CR 3298
                                    exRep.GenerateExceptionQC((Guid)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReagentGuid"], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], Guid.Empty, Guid.Empty, sPreviousTestResult, cellTextFuture, "CC", this._testingTech);
									this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityCCException"] = exRep;
								}
							}
							else
							{
								c.Text = string.Empty;
								DataTable dt = ((DataView)dgRack.DataSource).Table;
								dt.Rows[row][column] = c.Text;
								e.Handled = true;
								return;
							}
						}
					}
					else
					{
						//if there is no decrease in reactivity we should clean exception object from DataTable
						if (column == 5)
						{
							this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityISException"] = DBNull.Value;
						}
						else if (column == 6)
						{
							this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityIATException"] = DBNull.Value;
						}
						else if (column == 7)
						{
							this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityCCException"] = DBNull.Value;
						}
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				}

				if (minimumResult == "0" && cellTextFuture == "0" && column == 6)
				{
					this._dtRackTestResults[this._nActiveRack].Rows[row]["ReadOnlyCcResults"] = false;
				}

				if ((minimumResult == "0" && cellTextFuture != "0" && column != 7) ||
					(column == 7 && (int) resultLookup["W"] > (int) resultLookup[cellTextFuture]) ||
					(int) resultLookup[minimumResult] > (int) resultLookup[cellTextFuture])
				{
					Common.Utility.MessageBeep();
					DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC028.OverrideTestResult());
					if (result == DialogResult.Yes)
					{
						if (minimumResult == "0" && cellTextFuture != "0" && column == 6)
						{
							this._dtRackTestResults[this._nActiveRack].Rows[row]["ReadOnlyCcResults"] = true;
							this._dtRackTestResults[this._nActiveRack].Rows[row]["CcResults"] = string.Empty;
						}

						c.Text = cellTextFuture;
						c.SelectionStart = c.SelectionLength + 1;
						DataTable dtSource = ((DataView)dgRack.DataSource).Table;
						dtSource.Rows[row][column] = c.Text;
				
						_lastValidRow = row;
						_lastValidColumn = column;
						SetNextCell();
					}
					else
					{
						c.Text = string.Empty;
						DataTable dtSource = ((DataView)dgRack.DataSource).Table;
						dtSource.Rows[row][column] = c.Text;
						if (column == 5)
						{
							this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityISException"] = DBNull.Value;
						}
						else if (column == 6)
						{
							this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityIATException"] = DBNull.Value;
						}
						else if (column == 7)
						{
							this._dtRackTestResults[this._nActiveRack].Rows[row]["DecreaseInReactivityCCException"] = DBNull.Value;
						}
					}
				}
				else
				{
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					DataTable dtSource = ((DataView)dgRack.DataSource).Table;
					dtSource.Rows[row][column] = c.Text;
				
					_lastValidRow = row;
					_lastValidColumn = column;
					SetNextCell();
				}

				this._keyPressEventHandled = false;
			}
			else
			{
				Common.Utility.MessageBeep();
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InvalidKeyPressed());
			}

			e.Handled = true;
			return;			
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dcTextKeyTrapCol_TextChanged(object sender, EventArgs e)
		{
			if (this._keyPressEventHandled || this.dgRack.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgRack.CurrentCell.RowNumber;
				int column = this.dgRack.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgRack.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						regPattern = @"(\A[WM01234]\z)";

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							
							UpdateIndicator(row, this._nActiveRack);
							this.dgRack.Refresh();
							this.btnOK.EnabledButton = IsRackReadyToSave(this._nActiveRack);

							this._keyPressEventHandled = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandled = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
						//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandled = true;
						dt.Rows[row][column] = "";

						UpdateIndicator(row, this._nActiveRack);
						this.dgRack.Refresh();
						this.btnOK.EnabledButton = IsRackReadyToSave(this._nActiveRack);

						this._keyPressEventHandled = false;
					}
				}
			}
		}

		private void dgRack_CurrentCellChanged(object sender, System.EventArgs e)
		{
			int row = dgRack.CurrentCell.RowNumber;
			string minimumResult = this._dtRackTestResults[this._nActiveRack].Rows[row]["ExpectedMinimumReactions"].ToString().Trim();	// minimum result
			string testPhase = this._dtRackTestResults[this._nActiveRack].Rows[row]["ReactivityPhaseText"].ToString().Trim();		// test phase code

			//			if (row != 0 || this.dgRack.CurrentCell.ColumnNumber != 0)
			//			{
			if (this.dgRack.CurrentCell.ColumnNumber < _LeftHiddenColumn ||
				this.dgRack.CurrentCell.ColumnNumber > _RightHiddenColumn)
			{
				if (testPhase == "IS" || testPhase == "IS/IAT")
				{
					this.dgRack.CurrentCell = new DataGridCell(row, 5);
				}
				else
				{
					this.dgRack.CurrentCell = new DataGridCell(row, 6);
				}
			}
			else
			{
				if ((this.dgRack.CurrentCell.ColumnNumber == 5 && (bool)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReadOnlyIsResults"] == true) ||
					(this.dgRack.CurrentCell.ColumnNumber == 6 && (bool)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReadOnlyIatResults"] == true) ||
					(this.dgRack.CurrentCell.ColumnNumber == 7 && (bool)this._dtRackTestResults[this._nActiveRack].Rows[row]["ReadOnlyCcResults"] == true))

					SetNextCell();
				else if (testPhase == "IS" && this.dgRack.CurrentCell.ColumnNumber != 5)
				{
					SetNextCell();
				}
				else if (testPhase == "IAT")
				{
					if (minimumResult == "0")
					{
						if  (this.dgRack.CurrentCell.ColumnNumber == 5)
						{
							SetNextCell();
						}
						if ((this._dtRackTestResults[this._nActiveRack].Rows[row]["IatResults"].ToString().Trim() != "0" &&
							this._dtRackTestResults[this._nActiveRack].Rows[row]["IatResults"].ToString().Trim() != string.Empty))
						{
							if (this.dgRack.CurrentCell.ColumnNumber == 7)
							{
								SetNextCell();
							}
						}
					}
					else
					{
						if (this.dgRack.CurrentCell.ColumnNumber != 6)
						{
							SetNextCell();
						}
					}
				}
				else if (testPhase == "IS/IAT")
				{
					if (minimumResult != "0" ||
						(this._dtRackTestResults[this._nActiveRack].Rows[row]["IatResults"].ToString().Trim() != "0" &&
						 this._dtRackTestResults[this._nActiveRack].Rows[row]["IatResults"].ToString().Trim() != string.Empty))
					{
						if (this.dgRack.CurrentCell.ColumnNumber == 7)
						{
							SetNextCell();
						}
					}
				}
			}

			UpdateIndicator(_previousRow, this._nActiveRack);
			_previousRow = dgRack.CurrentCell.RowNumber;
			this.btnOK.EnabledButton = IsRackReadyToSave(this._nActiveRack);

		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult result;
			string sRackName = this._dtRacks.Rows[this._nActiveRack]["RackName"].ToString();
			Guid dailyQcWorklistGuid = Guid.Empty;
			bool bPartiallyTested;

			//CR 2792 Additional check to see if data on the grid are valid
			this.btnOK.EnabledButton = IsRackReadyToSave(this._nActiveRack);
			if (this.btnOK.EnabledButton == false)
				return;


			if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid) == false)
				dailyQcWorklistGuid = (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid];

			if (IsRackFullyTested() == true)
			{
				result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC028.SaveTestResults(sRackName));
				bPartiallyTested = false;
			}
			else
			{
				result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC028.SavePartialTestResults(sRackName));
				bPartiallyTested = true;
			}

			if (result == DialogResult.Yes)
			{
				try
				{
					for (int i=0; i<this._dtLotNumbers.Length; i++)
					{
						foreach(DataRow drLot in this._dtLotNumbers[i].Rows)
						{
							if (drLot.IsNull("ReagentExpiredException") == false)
							{
								if (this._dtRackTestResults[i].Select("ReagentGuid = '" + drLot["ReagentGuid"].ToString() + "'").Length > 0)
								{
									this._dtRackTestResults[i].Select("ReagentGuid = '" + drLot["ReagentGuid"].ToString() + "'")[0]["ReagentExpiredException"] = drLot["ReagentExpiredException"];
								}
							}
						}
					}
				
					this._workloadProcessIds  = new Common.WorkloadProcessID[1];
					this._workloadProcessIds[0] = Common.WorkloadProcessID.DailyRackQualityControlQC;

					byte[] rowVersion;
					if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.RowVersion) == false)
						rowVersion = (byte[])this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.RowVersion];
					else
						rowVersion = new byte[0];
					
					//CR 1441, 2173
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.DailyRackQualityControlQC);
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
					if (BOL.RackLot.SaveRackTests(this._dtRackTestResults[this._nActiveRack], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], rowVersion, bPartiallyTested, LogonUser.LogonUserDivisionCode,  Common.UpdateFunction.UC028FrmDailyReagentRackQC, this._workloadProcessIds, this._testingTech, this._testDateTime, (DateTime)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyControl.DailyAlertTime], dailyQcWorklistGuid) == true)
					{
						foreach(DataRow drRackTest in this._dtRackTestResults[this._nActiveRack].Rows)
						{
							if ((bool)drRackTest["TestWithReagent"] == false)
							{
								drRackTest["ReadOnlyIsResults"] = drRackTest["IsResults"].ToString().Equals(String.Empty) ? false : true;
								drRackTest["ReadOnlyIatResults"] = drRackTest["IatResults"].ToString().Equals(String.Empty) ? false : true;
								drRackTest["ReadOnlyCcResults"] = drRackTest["CcResults"].ToString().Equals(String.Empty) ? false : true;
							}
						}
						if (bPartiallyTested == false)
						{
							this.btnOK.Hide();
							dgRack.Enabled = false;
							this.btnInvalidate.EnabledButton = false;
						}
						if (this.tabResults.TabPages.Count == 1)
						{
							//Successful update, close windows.
							((FrmRecordLotNumbers)this.Tag).IsDirty=false;
							((FrmRecordLotNumbers)this.Tag).Close();
							this.IsDirty=false;
							this.Close();
							return;
						}
						else
						{
							this.RemoveTab();
						}
					}
					FocusOnTheFirstEditableCell();
				}
				catch(RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				}

			}
		}

		private void RemoveTab()
		{
			int newIndex = 0;
			int PreviousNumberOfTabs = this.tabResults.TabCount;
			int nNumberOfRacks = 0;
			int TabPageIndex = 0;
			int RackCounter = 0;
			int nCount = 0;

			DataTable[] newDTLotNumbers = new DataTable[this._dtLotNumbers.Length - 1];
			DataTable[] newDTRackTestResults = new DataTable[this._dtRackTestResults.Length - 1];
			DataTable newDTRacks = this._dtRacks.Clone();
			nCount = this._dtLotNumbers.Length;
			for(int i=0; i<nCount; i++)
			{
				if (i != this._nActiveRack)
				{
					newDTLotNumbers[newIndex] = this._dtLotNumbers[i];
					newDTRacks.Rows.Add(this._dtRacks.Rows[i].ItemArray);
					newIndex++;
				}
			}

			newIndex = 0;
			for (int i=0; i<this._dtRackTestResults.Length; i++)
			{
				if (i != this._nActiveRack)
				{
					newDTRackTestResults[newIndex] = this._dtRackTestResults[i];
					newIndex++;
				}
			}

			this._dtLotNumbers = newDTLotNumbers;
			this._dtRackTestResults = newDTRackTestResults;
			this._dtRacks = newDTRacks;

			//CR 2718 added check for QCOfflineIndicator
			foreach(DataRow drRack in _dtRacks.Rows)
			{
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false &&
					drRack.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true &&
						(bool)drRack[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
						nNumberOfRacks++;
				}
				else
				{
					nNumberOfRacks++;
				}
			}

			//creating new tabs
			this.pageRacks = new System.Windows.Forms.TabPage[nNumberOfRacks];

			//CR 2718 added check for QCOfflineIndicator
			foreach(DataRow drRack in _dtRacks.Rows)
			{
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false &&
					drRack.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true &&
					   (bool)drRack[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
					{
						this.pageRacks[TabPageIndex] = new System.Windows.Forms.TabPage(drRack["RackName"].ToString());
						this.pageRacks[TabPageIndex].Tag = RackCounter;
						this.pageRacks[TabPageIndex].Location = new System.Drawing.Point(4, 23);
						this.pageRacks[TabPageIndex].Size = new System.Drawing.Size(488, 375);
						this.pageRacks[TabPageIndex].TabIndex = TabPageIndex;
						TabPageIndex++;
					}
				}
				else
				{
					this.pageRacks[TabPageIndex] = new System.Windows.Forms.TabPage(drRack["RackName"].ToString());
					this.pageRacks[TabPageIndex].Tag = RackCounter;
					this.pageRacks[TabPageIndex].Location = new System.Drawing.Point(4, 23);
					this.pageRacks[TabPageIndex].Size = new System.Drawing.Size(488, 375);
					this.pageRacks[TabPageIndex].TabIndex = TabPageIndex;
					TabPageIndex++;
				}
				RackCounter++;
			}

			this.tabResults.TabPages.AddRange(this.pageRacks);

			//removing old tabs
			for (int i=PreviousNumberOfTabs-1 ; i>=0 ; i--)
			{
				this.tabResults.TabPages.RemoveAt(i);
			}


			this.tabResults.SelectedIndex = 0;
			this._nActiveRack = (int)this.tabResults.SelectedTab.Tag;

			((FrmRecordLotNumbers)this.Tag).RemoveTab(this._nActiveRack);
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			bool showCancelMessage = false;

			for (int i=0; i<this._dtRacks.Rows.Count; i++)
			{
				if (IsRackReadyToSave(i) == true)
					showCancelMessage = true;
			}

			if (showCancelMessage == true)
			{
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC028.CancelTestResults());
				if(result == DialogResult.Yes)
				{
					CancelRecentlyEnteredResults();
				}
				else
					return;
			}

			((FrmRecordLotNumbers)this.Tag).Enabled = true;
			this.Hide();
		}

		private void FrmDailyReagentRackQC_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			CancelRecentlyEnteredResults();
			((FrmRecordLotNumbers)this.Tag).Enabled = true;
			this.Hide();
			e.Cancel = true;
		}

		/// <summary>
		/// Clears the recently entered test results
		/// </summary>
		private void CancelRecentlyEnteredResults()
		{
			int nRow;
			int nCount = 0;
			nCount = this._dtRackTestResults.Length ;
			for(int i=0 ; i<nCount ; i++)
			{
				nRow = 0;
				foreach(DataRow drRackTest in this._dtRackTestResults[i].Rows)
				{
					if ((bool)drRackTest["ReadOnlyIsResults"] == false)
					{
						drRackTest["IsResults"] = string.Empty;
					}
					if ((bool)drRackTest["ReadOnlyIatResults"] == false)
					{
						drRackTest["IatResults"] = string.Empty;
					}
					if ((bool)drRackTest["ReadOnlyCcResults"] == false)
					{
						drRackTest["CcResults"] = string.Empty;
					}
					UpdateIndicator(nRow, i);
					nRow++;
				}
			}
		}

		/// <summary>
		/// Inactivates test results for rack
		/// </summary>
		/// <param name="nRack"></param>
		/// <param name="comment"></param>
		/// <returns></returns>
		private bool InactivateTestResultsForRack(int nRack, string comment)
		{
			bool retVal;
			Guid dailyQcWorklistGuid = Guid.Empty;

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Partially_completed_QC_deleted, comment, Common.LogonUser.LogonUserName);
			DataTable dtQcInactivatedReagents = exRep.GenerateExceptionQCInactivation(this._dtRacks.Rows[nRack][Common.VbecsTables.Rack.RackName].ToString(), this._dtRackTestResults[this._nActiveRack], _testingTech);

			if (this._dtRacks.Rows[nRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid) == true)
			{
				dailyQcWorklistGuid = Guid.Empty;
			}
			else
			{
				dailyQcWorklistGuid = (Guid)this._dtRacks.Rows[nRack][Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid];
			}

			try
			{
				retVal = BOL.RackTest.InactivateRackTestResults(dailyQcWorklistGuid, exRep.ExceptionData.Table, dtQcInactivatedReagents, Common.UpdateFunction.UC028FrmDailyReagentRackQC);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				retVal = false;
			}

			if (retVal == true)
			{
				foreach(DataRow drRackTest in this._dtRackTestResults[nRack].Rows)
				{
					drRackTest["ReadOnlyIsResults"] = false;
					drRackTest["IsResults"] = string.Empty;
					drRackTest["IsGuid"] = DBNull.Value;
					drRackTest["IsRowVersion"] = DBNull.Value;
					drRackTest["ReadOnlyIatResults"] = false;
					drRackTest["IatResults"] = string.Empty;
					drRackTest["IatGuid"] = DBNull.Value;
					drRackTest["IatRowVersion"] = DBNull.Value;
					drRackTest["ReadOnlyCcResults"] = false;
					drRackTest["CcResults"] = string.Empty;
					drRackTest["CcGuid"] = DBNull.Value;
					drRackTest["CcRowVersion"] = DBNull.Value;
					drRackTest["Insert"] = true;
				}
			}
			return retVal;
		}

		private void btnInvalidate_Click(object sender, System.EventArgs e)
		{
			if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid) == false)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Invalidate QC testing?", "Invalidating this worksheet will necessitate starting over. Continue?", "RS");

                dlg.ShowDialogFromLockedParent(this, false);
                if (dlg.DialogResult == DialogResult.OK)     //TODO: Check for Abort(lockexpired)?
				{
					if (InactivateTestResultsForRack(this._nActiveRack, dlg.Comment) == true)
					{
						foreach(DataRow drRackTest in this._dtRackTestResults[this._nActiveRack].Rows)
						{
							drRackTest["ReadOnlyIsResults"] = false;
							drRackTest["ReadOnlyIatResults"] = false;
							drRackTest["ReadOnlyCcResults"] = false;

							drRackTest["IsResults"] = string.Empty;
							drRackTest["IatResults"] = string.Empty;
							drRackTest["CcResults"] = string.Empty;

							drRackTest["TestResultIndicator"] = string.Empty;
						}

						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid] = DBNull.Value;
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator] = DBNull.Value;
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] = true;
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] = false;

						FocusOnTheFirstEditableCell();
					}
				}
			}
			else
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC028.ClearTestResults()) == DialogResult.Yes)
				{
					foreach(DataRow drRackTest in this._dtRackTestResults[this._nActiveRack].Rows)
					{
						drRackTest["ReadOnlyIsResults"] = false;
						drRackTest["ReadOnlyIatResults"] = false;
						drRackTest["ReadOnlyCcResults"] = false;

						drRackTest["IsResults"] = string.Empty;
						drRackTest["IatResults"] = string.Empty;
						drRackTest["CcResults"] = string.Empty;

						drRackTest["TestResultIndicator"] = string.Empty;
					}

					FocusOnTheFirstEditableCell();
				}
			}
		}

		private void FrmDailyReagentRackQC_Activated(object sender, System.EventArgs e)
		{
			FocusOnTheFirstEditableCell();
		}

		private void FrmDailyReagentRackQC_VisibleChanged(object sender, System.EventArgs e)
		{
			if (this.Visible == true)
			{
				//creating new tabs
				int PreviousNumberOfTabs = this.tabResults.TabCount;
				int nNumberOfRacks = 0;
				int TabPageIndex = 0;
				int RackCounter = 0;

				//CR 2718 added check for QCOfflineIndicator
				foreach(DataRow drRack in _dtRacks.Rows)
				{
					if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false &&
						drRack.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
					{
						if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true &&
							(bool)drRack[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
							nNumberOfRacks++;
					}
					else
					{
						nNumberOfRacks++;
					}
				}

				this.pageRacks = new System.Windows.Forms.TabPage[nNumberOfRacks];

				foreach(DataRow drRack in _dtRacks.Rows)
				{
					//CR 2718 added check for QCOfflineIndicator
					if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false &&
						drRack.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
					{
						if((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true &&
						   (bool)drRack[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
						{
							this.pageRacks[TabPageIndex] = new System.Windows.Forms.TabPage(drRack["RackName"].ToString());
							this.pageRacks[TabPageIndex].Tag = RackCounter;
							this.pageRacks[TabPageIndex].Location = new System.Drawing.Point(4, 23);
							this.pageRacks[TabPageIndex].Size = new System.Drawing.Size(488, 375);
							this.pageRacks[TabPageIndex].TabIndex = TabPageIndex;
							TabPageIndex++;
						}
					}
					else
					{
						this.pageRacks[TabPageIndex] = new System.Windows.Forms.TabPage(drRack["RackName"].ToString());
						this.pageRacks[TabPageIndex].Tag = RackCounter;
						this.pageRacks[TabPageIndex].Location = new System.Drawing.Point(4, 23);
						this.pageRacks[TabPageIndex].Size = new System.Drawing.Size(488, 375);
						this.pageRacks[TabPageIndex].TabIndex = TabPageIndex;
						TabPageIndex++;
					}
					RackCounter++;
				}

				this.tabResults.TabPages.AddRange(this.pageRacks);

				//removing old tabs
				for (int i=PreviousNumberOfTabs-1 ; i>=0 ; i--)
				{
					this.tabResults.TabPages.RemoveAt(i);
				}

				this._nActiveRack = (int)this.tabResults.SelectedTab.Tag;

				if (IsRackFilled() == true &&
					this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) == false)
				{
					this.btnOK.Hide();
					dgRack.Enabled = false;
					this.btnInvalidate.EnabledButton = false;
				}
				else
				{
					this.btnOK.Show();
					dgRack.Enabled = true;
					this.btnInvalidate.EnabledButton = true;
					this._lastValidColumn = 0;
					this._lastValidRow = 0;
					FocusOnTheFirstEditableCell();
				}

				//CR 2696 filling values for any missing TestWithReagentGuid column

				for (int i=0; i<this._dtRackTestResults.Length; i++)
				{
					foreach (DataRow drRackTest in this._dtRackTestResults[i].Rows)
					{
						if ((bool)drRackTest["TestWithReagent"] == false &&
							drRackTest.IsNull(Common.VbecsTables.RackTest.TestWithReagentGuid) == true)
						{
							DataRow[] testWithReagents = new DataRow[0];
							testWithReagents = this._dtLotNumbers[i].Select(Common.VbecsTables.Reagent.ReagentTypeId + " = '" + drRackTest[Common.VbecsTables.RackLot.TestWithId].ToString() + "'");

							if (testWithReagents.Length > 0)
							{
								drRackTest[Common.VbecsTables.RackTest.TestWithReagentGuid] = (Guid)testWithReagents[0][Common.VbecsTables.Reagent.ReagentGuid];
							}
						}
					}
				}
			}
			this.btnOK.EnabledButton = this.IsRackReadyToSave(this._nActiveRack);
		}

		private void dgRack_LostFocus(object sender, EventArgs e)
		{
			if (e.GetType().FullName == typeof(CONTROLS.VbecsGridEventArgs).FullName)
			{
				if (((CONTROLS.VbecsGridEventArgs)e).TabKeyPressed)
				{
					this.SelectNextControl(this.dgRack,true,true,false,false);
				}
			}
		}
	}

	/// <summary>
	/// Class DataGridKeyTrapTextBoxColumn
	/// </summary>
	public class DataGridKeyTrapTextBoxColumn : DataGridTextBoxColumn
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private bool _processAcross = true;

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/6/2003</CreationDate>
		/// <summary>
		///  Data grid key trap text box constructor.
		/// </summary>
		public DataGridKeyTrapTextBoxColumn() : base()
		{
			InitializeComponent();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1611"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Process across indicator set to true.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="1612"> 
		///		<ExpectedInput>False</ExpectedInput>
		///		<ExpectedOutput>Process across indicator set to false.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///
		/// <summary>
		/// Gets or sets whether the grid will be processed from left to right.  If this value is false
		/// the grid will be processed from top to bottom.
		/// </summary>
		public bool ProcessAcross
		{
			get
			{
				return _processAcross;
			}
			set 
			{
				_processAcross = value;
				//_keyTrapTextBox.ProcessAcross = value;
			}
		}
		#endregion 

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/11/2003</CreationDate>
		///
		/// <summary>
		/// This event is used to update the indicator column of the datagrid.
		/// </summary>
		/// <param name="g"></param>
		/// <param name="_Bounds"></param>
		/// <param name="_Source"></param>
		/// <param name="_RowNum"></param>
		/// <param name="_BackBrush"></param>
		/// <param name="_ForeBrush"></param>
		/// <param name="_AlignToRight"></param>
		protected override void Paint(Graphics g, Rectangle _Bounds, CurrencyManager _Source,
			int _RowNum, Brush _BackBrush, Brush _ForeBrush, bool _AlignToRight) 
		{
			try
			{  
				DataGrid grid = this.DataGridTableStyle.DataGrid;
				Common.ReactivityPhase reactivityPhase = (Common.ReactivityPhase) Convert.ToInt32(grid[_RowNum, 9].ToString());

				if (this.HeaderText.Trim() == "IS*")
				{		
					_BackBrush = reactivityPhase.Equals(Common.ReactivityPhase.IAT) ? Brushes.LightGray : Brushes.White;
				}
				else if (this.HeaderText.Trim() == "IAT*" )
				{
					_BackBrush = reactivityPhase.Equals(Common.ReactivityPhase.IS) ? Brushes.LightGray : Brushes.White;
				}
				else if (this.HeaderText.Trim() == "CC*")
				{
					if ((reactivityPhase == Common.ReactivityPhase.ISandIAT  && grid[_RowNum, 3].ToString().Trim() == "0" && (grid[_RowNum, 6].ToString().Trim() == string.Empty || grid[_RowNum, 6].ToString().Trim() == "0")) ||
						(reactivityPhase == Common.ReactivityPhase.IAT && grid[_RowNum, 3].ToString().Trim() == "0" && (grid[_RowNum, 6].ToString().Trim() == string.Empty || grid[_RowNum, 6].ToString().Trim() == "0")))
					{
						_BackBrush = Brushes.White;
					}
					else
					{
						_BackBrush = Brushes.LightGray;
					}
				}
				else 
				{
					_BackBrush = Brushes.White;
				}
			}
			catch(Exception)
			{ /* empty catch */ }
			finally
			{
				base.Paint(g, _Bounds, _Source, _RowNum, _BackBrush, _ForeBrush, _AlignToRight);
			}
		}
	
	}
}

